<?php
// Közvetlen hozzáférés megakadályozása
if (!defined('ABSPATH')) {
    exit;
}

// Shortcode regisztrálása
function gardeningo_elotte_utana_slider_shortcode($atts) {
    $atts = shortcode_atts(array(
        'limit' => 10, // Hány bejegyzést jelenítsen meg
    ), $atts, 'elotte_utana_slider');
    
    // Csak a saját stílusokat és scripteket töltsük be, verzió frissítve
    wp_enqueue_style('gardeningo-slider-css', plugin_dir_url(__FILE__) . 'css/slider.css', array(), '1.1.1');
    wp_enqueue_script('jquery');
    wp_enqueue_script('gardeningo-slider-js', plugin_dir_url(__FILE__) . 'js/slider.js', array('jquery'), '1.1.1', true);

    // Referencia bejegyzések lekérése
    $args = array(
        'post_type'      => 'referencia',
        'posts_per_page' => intval($atts['limit']),
        'post_status'    => 'publish',
    );
    
    $referencia_query = new WP_Query($args);
    
    // Külső csomagoló div az 1200px szélességhez - fontos az overflow: visible!
    $output = '<div class="elotte-utana-wrapper-container">';
    
    // Slider HTML felépítése - half slider + loop + jobb oldali túlnyúlás
    $output .= '<div class="gardeningo-elotte-utana-slider">';
    
    // Slider tartalom
    $output .= '<div class="slider-container">';
    $output .= '<div class="slider-track">';
    
    if ($referencia_query->have_posts()) {
        while ($referencia_query->have_posts()) {
            $referencia_query->the_post();
            
            // Egyedi mezők lekérése
            $kep_elotte = get_field('kep_elotte');
            $kep_utana = get_field('kep_b');
            $sima_kep = get_field('sima_kep');
            
            $slide_id = 'slide-' . get_the_ID();
            $output .= '<div class="slider-slide" id="' . esc_attr($slide_id) . '">';
            $output .= '<div class="elotte-utana-container">';
            
            // Ellenőrizzük, hogy van-e feltöltve egyszerű kép
            if ($sima_kep && isset($sima_kep['url'])) {
                // Egyszerű kép megjelenítése
                $output .= '<div class="simple-image-container">';
                $output .= '<img src="' . esc_url($sima_kep['url']) . '" alt="' . esc_attr(get_the_title()) . '" class="simple-image">';
                $output .= '</div>';
            } 
            // Ha nincs egyszerű kép, de van előtte-utána kép, akkor használjuk az előtte-utána csúszkát
            elseif ($kep_elotte && isset($kep_elotte['url']) && $kep_utana && isset($kep_utana['url'])) {
                // Saját előtte-utána megvalósítás
                $output .= '<div class="custom-before-after">';
                $output .= '<div class="before-image" style="background-image: url(' . esc_url($kep_elotte['url']) . ');"></div>';
                $output .= '<div class="after-image" style="background-image: url(' . esc_url($kep_utana['url']) . ');"></div>';
                $output .= '<div class="slider-handle"><div class="slider-handle-line"></div></div>';
                $output .= '</div>'; // custom-before-after bezárása
            }
            // Ha egyik mező sincs kitöltve, akkor egy placeholder-t jelenítünk meg
            else {
                $output .= '<div class="no-image-placeholder">';
                $output .= '<p>Nincs kép feltöltve</p>';
                $output .= '</div>';
            }
            
            // Cím a kép alatt
            $output .= '<h3 class="projekt-cim">' . get_the_title() . '</h3>';
            
            $output .= '</div>'; // elotte-utana-container bezárása
            $output .= '</div>'; // slider-slide bezárása
        }
    }
    
    $output .= '</div>'; // slider-track bezárása
    $output .= '</div>'; // slider-container bezárása
    
    // Navigációs gombok külön konténerben a slider alatt
    $output .= '<div class="slider-navigation-container">';
    $output .= '<button class="slider-nav slider-nav-prev" aria-label="Előző">&lt;</button>';
    $output .= '<button class="slider-nav slider-nav-next" aria-label="Következő">&gt;</button>';
    $output .= '</div>'; // slider-navigation-container bezárása
    
    $output .= '</div>'; // gardeningo-elotte-utana-slider bezárása
    $output .= '</div>'; // elotte-utana-wrapper-container bezárása
    
    wp_reset_postdata();
    
    return $output;
}
add_shortcode('elotte_utana_slider', 'gardeningo_elotte_utana_slider_shortcode');