document.addEventListener('DOMContentLoaded', function() {
    // Az összes slider inicializálása
    const sliders = document.querySelectorAll('.gardeningo-elotte-utana-slider');
    
    sliders.forEach(function(slider) {
        initSlider(slider);
        initAllBeforeAfterSliders(slider);
    });
    
    // Slider funkcionalitás inicializálása
    function initSlider(slider) {
        const track = slider.querySelector('.slider-track');
        const slides = slider.querySelectorAll('.slider-slide');
        const prevBtn = slider.querySelector('.slider-nav-prev');
        const nextBtn = slider.querySelector('.slider-nav-next');
        
        // Ha túl kevés dia van, még mindig engedélyezzük a navigációt a loop miatt
        if (slides.length <= 1) {
            if (prevBtn) prevBtn.style.display = 'none';
            if (nextBtn) nextBtn.style.display = 'none';
            return;
        }
        
        // Slide-ok számozása és az első elemek aktiválása
        slides.forEach(function(slide, index) {
            slide.setAttribute('data-index', index);
            
            // Az első két slide legyen aktív (2 dia + 1 fél beállítás)
            if (index < 2) {
                slide.classList.add('active');
            }
        });
        
        let currentPosition = 0;
        const slideWidth = 45; // Egy dia szélessége százalékban (45% a 2 dia + 1 fél beállításnál)
        const maxPosition = slides.length; // Végtelen loop miatt a max pozíció is végtelen lehet
        
        // Előző diák gomb funkció
        if (prevBtn) {
            prevBtn.addEventListener('click', function() {
                goToPosition(currentPosition - 1);
            });
        }
        
        // Következő diák gomb funkció
        if (nextBtn) {
            nextBtn.addEventListener('click', function() {
                goToPosition(currentPosition + 1);
            });
        }
        
        // Állítsuk be a kezdő pozíciót
        updateSliderPosition(0);
        
        // Pozíció váltás funkció
        function goToPosition(position) {
            // Loop kezelése: ha elértük a végét, kezdjük elölről
            if (position < 0) {
                position = slides.length - 1;
            } else if (position >= slides.length) {
                position = 0;
            }
            
            // Ha a pozíció nem változott, ne tegyünk semmit
            if (position === currentPosition) return;
            
            // Frissítjük a jelenlegi pozíciót és a slider megjelenítését
            updateSliderPosition(position);
            
            // Előtte-utána csúszkák újrainicializálása
            initVisibleBeforeAfterSliders(slider);
        }
        
        // Slider pozíció frissítése
        function updateSliderPosition(position) {
            // Frissítjük a jelenlegi pozíciót
            currentPosition = position;
            
            // Kiszámítjuk a transzformációt, figyelembe véve a loop-ot
            const translateX = -position * slideWidth;
            track.style.transform = `translateX(${translateX}%)`;
            
            // Aktív slide-ok frissítése
            slides.forEach(function(slide, index) {
                // Kiszámoljuk a relatív pozíciót a loop-ban
                let relativeIndex = (index - position + slides.length) % slides.length;
                
                // Az első két slide legyen aktív (2 dia + 1 fél beállítás)
                if (relativeIndex < 2) {
                    slide.classList.add('active');
                } else {
                    slide.classList.remove('active');
                }
            });
        }
        
        // Automatikus csúsztatás (opcionális)
        let autoplayInterval;
        
        function startAutoplay() {
            autoplayInterval = setInterval(function() {
                goToPosition(currentPosition + 1);
            }, 5000); // 5 másodpercenként váltás
        }
        
        function stopAutoplay() {
            clearInterval(autoplayInterval);
        }
        
        // Autoplay indítása (ha szeretnéd, távolítsd el a kommentet)
        // startAutoplay();
        
        // Autoplay megállítása hover esetén (ha szeretnéd, távolítsd el a kommentet)
        // slider.addEventListener('mouseenter', stopAutoplay);
        // slider.addEventListener('mouseleave', startAutoplay);
        
        // Responsive viselkedés kezelése
        function handleResponsive() {
            // Visszaállítjuk alaphelyzetbe a slidert minden ablakméret változásnál
            updateSliderPosition(0);
        }
        
        // Ablakméret változás esemény figyelése
        window.addEventListener('resize', handleResponsive);
        
        // Touch eseménykezelés mobilon történő swipe-oláshoz
        let touchStartX = 0;
        let touchEndX = 0;
        
        slider.addEventListener('touchstart', function(e) {
            touchStartX = e.changedTouches[0].screenX;
        });
        
        slider.addEventListener('touchend', function(e) {
            touchEndX = e.changedTouches[0].screenX;
            handleSwipe();
        });
        
        function handleSwipe() {
            const threshold = 50; // Swipe érzékenység
            
            if (touchEndX + threshold < touchStartX) {
                // Balra swipe
                goToPosition(currentPosition + 1);
            } else if (touchEndX > touchStartX + threshold) {
                // Jobbra swipe
                goToPosition(currentPosition - 1);
            }
        }
    }
    
    // Az összes előtte-utána csúszka inicializálása
    function initAllBeforeAfterSliders(slider) {
        const beforeAfters = slider.querySelectorAll('.custom-before-after');
        
        beforeAfters.forEach(function(beforeAfter) {
            initBeforeAfterSlider(beforeAfter);
        });
    }
    
    // Csak a látható előtte-utána csúszkák inicializálása
    function initVisibleBeforeAfterSliders(slider) {
        // Az aktív diák előtte-utána csúszkáinak inicializálása
        const activeSlides = slider.querySelectorAll('.slider-slide.active');
        
        activeSlides.forEach(function(slide) {
            const beforeAfter = slide.querySelector('.custom-before-after');
            if (beforeAfter && !beforeAfter.getAttribute('data-initialized')) {
                initBeforeAfterSlider(beforeAfter);
            }
        });
    }
    
    // Egyetlen előtte-utána csúszka inicializálása
    function initBeforeAfterSlider(beforeAfter) {
        if (!beforeAfter || beforeAfter.getAttribute('data-initialized') === 'true') return;
        
        const handle = beforeAfter.querySelector('.slider-handle');
        const afterImage = beforeAfter.querySelector('.after-image');
        
        if (!handle || !afterImage) return;
        
        let isActive = false;
        
        // Egérlenyomás esemény
        handle.addEventListener('mousedown', startSlide);
        // Érintés esemény mobilon
        handle.addEventListener('touchstart', startSlide);
        
        // Csúszka kezdése
        function startSlide(e) {
            e.preventDefault();
            isActive = true;
        }
        
        // Csúszka mozgatása
        function moveSlide(e) {
            if (!isActive) return;
            
            let x;
            
            // Egér vagy érintés pozíció kiszámítása
            if (e.type === 'mousemove') {
                x = e.pageX;
            } else {
                x = e.touches[0].pageX;
            }
            
            // A pozíció relatív a konténerhez
            const containerRect = beforeAfter.getBoundingClientRect();
            let position = x - containerRect.left;
            
            // Korlátozzuk a mozgást a konténeren belül
            position = Math.max(0, Math.min(position, containerRect.width));
            
            // Százalékos pozíció kiszámítása
            const percentage = (position / containerRect.width) * 100;
            
            // Csúszka és kép pozicionálása
            handle.style.left = percentage + '%';
            afterImage.style.width = percentage + '%';
        }
        
        // Csúszka elengedése
        function endSlide() {
            isActive = false;
        }
        
        // Eseményfigyelők a dokumentumhoz
        document.addEventListener('mousemove', moveSlide);
        document.addEventListener('touchmove', moveSlide);
        document.addEventListener('mouseup', endSlide);
        document.addEventListener('touchend', endSlide);
        
        // Jelöljük, hogy már inicializáltuk ezt a csúszkát
        beforeAfter.setAttribute('data-initialized', 'true');
    }
});