/**
 * Harominka frontend JavaScript
 */
document.addEventListener('DOMContentLoaded', function() {
    // Find all harominka containers
    var containers = document.querySelectorAll('.harominka-container');
    
    // Handle each container
    containers.forEach(function(container) {
        var leftImage = container.querySelector('.harominka-image-left');
        var rightImage = container.querySelector('.harominka-image-right');
        
        // Make sure all elements exist
        if (!leftImage || !rightImage) {
            return;
        }
        
        // Initialize with default flex values
        leftImage.style.flex = '0.7'; // 70%
        rightImage.style.flex = '0.3'; // 30%
        
        // Hover on left image
        leftImage.addEventListener('mouseenter', function() {
            leftImage.style.flex = '0.7'; // 70%
            rightImage.style.flex = '0.3'; // 30%
        });
        
        // Hover on right image
        rightImage.addEventListener('mouseenter', function() {
            leftImage.style.flex = '0.3'; // 30%
            rightImage.style.flex = '0.7'; // 70%
        });
        
        // Reset when leaving container (optional, can be removed)
        container.addEventListener('mouseleave', function() {
            leftImage.style.flex = '0.7'; // 70%
            rightImage.style.flex = '0.3'; // 30%
        });
    });
});