/**
 * Harominka admin JavaScript
 */
jQuery(document).ready(function($) {
    // Handle media uploader
    $('.harominka-upload-image').on('click', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var targetId = button.data('target');
        
        // Create media frame
        var frame = wp.media({
            title: 'Select or Upload Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });
        
        // When image selected
        frame.on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            
            // Set image ID to hidden input
            $('#' + targetId).val(attachment.id);
            
            // Update preview
            var previewWrapper = button.siblings('.harominka-image-preview-wrapper');
            
            // Remove existing preview image
            previewWrapper.find('img').remove();
            
            // Add new preview image
            previewWrapper.append('<img src="' + attachment.url + '" class="harominka-image-preview" alt="Image preview" />');
            
            // Show remove button
            button.siblings('.harominka-remove-image').show();
        });
        
        // Open media frame
        frame.open();
    });
    
    // Handle remove image button
    $('.harominka-remove-image').on('click', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var targetId = button.data('target');
        
        // Clear hidden input
        $('#' + targetId).val('');
        
        // Remove preview image
        button.siblings('.harominka-image-preview-wrapper').find('img').remove();
        
        // Hide remove button
        button.hide();
    });
});